import { Tags } from "./interfaces.js";
/**
 * Quite the beast isn't it? This list contains all the fanfics gathered by the thread. For details
 * of the format please see the iFanfic interface in interfaces.ts.
 */
export const fanfics = [
    // This function can use the Fimfic API to *mostly* fill in the different fields. You still need
    // to manually add tags and of course the reviews, but it sped up things quite a bit.
    // You can control which stories to output with the `ids` field. The ID is part of the URL of
    // the fic. To use it, just pop it into the console on any fimfic site and it'll hopefully do
    // its magic.
    /*
    {
    const ids = [
    193313
    ]

    const promises = ids.map(id => fetch("https://www.fimfiction.net/api/story.php?story=" + id).then(r => r.json()))
    
    const template = (name, url, image, length, up, down, rating, desc) => `
        {
            name: "${name}",
            url: "${url}",
            image: "${image}",

                        tags: [],
            length: ${length},
            recommends: 2,
            
            desc: "${desc}",

            upVotes: ${up},
            downVotes: ${down},
            rating: "${rating}",
        },
    `
    
    Promise.all(promises).then(list => {
        let conc = ""
        
        for (let elem of list) {
        const story = elem.story
        const title = story.title
        const url = story.url
        const img = story.full_image
        const up = story.likes
        const down = story.dislikes
        const words = story.words
        const rating = ["E", "T", "M"][story.content_rating]
        const desc = story.short_description
        
        conc += template(title, url, img, words, up, down, rating, desc)
        }
        
        console.log(conc)
    })
    }
    */
    {
        name: "Days of Wasp and Spider",
        url: "https://www.fimfiction.net/story/6515/days-of-wasp-and-spider",
        image: "https://cdn-img.fimfiction.net/story/nipx-1483461805-6515-full",
        tags: [Tags.Adventure, Tags.SciFi, Tags.Dark],
        length: 233572,
        recommends: 6,
        desc: "SF (canon species only; no humans) Ponies were magically and genetically engineered to be the perfect servitor race. They are powerful, adaptable, intelligent and completely under the control of their creators. A laboratory accident frees one such pony from her mental chains, but how can one mare save herself and the rest of her kind if she doesn't even know she's a slave? <br>This is not the Equestria you know and these are not your little ponies... not yet, anyway.<br><br>Tags: Adventure, Diamond Dogs, Gryphons, NO HUMANS (did I mention that already?)<br>Other tags: historical, mind control, Clarke's 3rd Law, excessive use of high energy physics, before they were famous.",
        reviews: [
            "Also very very very good. It and it's sequel were both very immersive and it did a modern setting well. I'm convinced that changelings are a diamond dog experiment. It's a very good sci-fi story.",
            "Duh. DOWAS is a sci-fi powerhouse that plays its immensely inventive premise with absolute narrative conviction. It's genuinely one of the most compelling pieces of fiction I've ever read, but its the ending, such a profound form of gut-quaking epic tragedy, that really pushes the pair of stories into that masterclass. It's a brick, but it's a fine brick.",
            "Possibly one of the best \"hard\" sci-fi stories around. (I say \"hard\" in quotes because I'm not a sci-fi connoisseur; it sure seems hard to me, though.) It's got excellent AU worldbuilding, really great action, compelling characters, everything you could want. I read it years ago so I'm struggling to really come up with specifics other than \"everything I remember about it is good\", but it's good.  This is one recommendation but it includes Final Solution, which is the direct sequel that picks up the action right away. Read both."
        ],
        upVotes: 1218,
        downVotes: 29,
        rating: "T"
    },
    {
        name: "Background Pony",
        url: "https://www.fimfiction.net/story/19198/background-pony",
        image: "https://cdn-img.fimfiction.net/story/dv8q-1585877781-19198-full",
        tags: [Tags.Random, Tags.Sad, Tags.SoL],
        length: 432377,
        recommends: 6,
        desc: "\"My name is [color=green]Lyra Heartstrings[/color], and you will not remember me.  You won't even remember this conversation.  Just like with everypony else I've ever met, everything I do or say will be forgotten.  Every letter I've written will appear blank; every piece of evidence I've left behind will end up missing.  I'm stuck here in Ponyville because of the same curse that has made me so forgettable.  Still, that doesn't stop me from doing the one thing that I love: making music.  If my melodies find their way into your heart, then there is still hope for me.  If I can't prove that I exist, I can at least prove that my love for each and every one of you exists.  Please, listen to my story, my symphony, for it is me.\"<br><br>Cover pic by Spotlight: askspotlight.tumblr.com",
        reviews: [
            "A war between the spirit and defeat. BGP places a magnifying glass over our beloved characters, revealing beauty and wear. It asks questions I didn't know were written in my heart. The longest single fic I've read to completion, never feeling like I wanted to skip ahead.",
            "This recommendation comes with a caveat to would-be readers. The story is very long and the prose is known to be slow and purple. Some people enjoy it and some get immediately bored. If you've read the first chapter and it feels insufferable, then there's no reason to continue. On the other hand, if you've read the first chapter and you want to keep going, then a fantastic story awaits you. Its main flaw, again, is that it's just so long. But in my opinion, the final payoff is absolutely worth it.",
            "I'm ashamed to admit I didn't give this story a chance earlier. It gets obnoxiously pretentious at times but fuck me if it's not shaping up to be one of the best fics I'll have read by the end of this year. ",
            "Absolutely incredible atmosphere and a very delightful prose (albeit too purple for some). If you like rich descriptions and overwhelmingly gloomy atmosphere, look no further. It's one of the rare pony classics that stood the test of time. Some of the ideas originally featured in this story became so popular that they got adopted by the rest of the fandom. And as far as I know, no other pony fanfiction was ever included in Boston University's recommended reading list."
        ],
        upVotes: 6601,
        downVotes: 235,
        rating: "T"
    },
    {
        name: "Mendacity",
        url: "https://www.fimfiction.net/story/26192/mendacity",
        image: "https://cdn-img.fimfiction.net/story/2dzq-1432432188-26192-full",
        tags: [Tags.Romance, Tags.Adventure],
        length: 74794,
        recommends: 5,
        desc: "Bon Bon's voice is funny, and that's about all that anypony who meets her notices, as her marefriend Lyra soon steals the spotlight with her explosive personality, strange obsessions, and curious beliefs. And why not? Bon Bon is, after all, a perfectly ordinary, boring pony in every way but two: her voice, and the carefully kept secret that she isn't really a pony.<br><br>(Edit:)  Now with an [url=https://drive.google.com/file/d/0B9drDXIilFv5RDVCY1Rralo2aklxUFFUWGdvbzFSWks1dzNJ/edit]annotated version[/url], courtesy of the incomparable [url=http://www.fimfiction.net/user/Shoggoth+Lord]Shoggoth Lord![/url]",
        reviews: [
            "The changeling story, bar none and the one that defined the \"changeling Bon Bon\" subgenre. The only thing disappointing about its fae worldbuilding is the fact it never caught on in the fandom and was instead crowded out by hiveminds and egg fetishes. A must read for any new reader interesting in changelings.",
            "I have a soft spot for stories about faerie, or stories that pull deeply from mythology. I love Pirene too (but I didn't recommend it because, honestly, a lot of it feels like it's not really about ponies; it's a great story but I wouldn't put it on the starter kit for pony fanfics). Mendacity, however, is definitely pony, while at the same time blending in a world of sprites and faeries - of celtic myths and folklore - into a fantastic narrative whose main crippling flaw is that it's far too short. It's left a craving that I've not been able to satisfy since, because nothing else in the same vein exists.",
            "Good-to-excellent characterization. The most striking thing about this fic is the painting of a strange world outside the bounds of civilization. It's a joy to read out loud. "
        ],
        upVotes: 2258,
        downVotes: 37,
        rating: "E"
    },
    {
        name: "The Best Night Ever",
        url: "https://www.fimfiction.net/story/18087/the-best-night-ever",
        image: "https://cdn-img.fimfiction.net/story/feje-1432427170-18087-full",
        tags: [Tags.Romance, Tags.Adventure, Tags.Comedy],
        length: 53935,
        recommends: 4,
        desc: "Prince Blueblood thought the Grand Galloping Gala was over. He thought he could just go to sleep and put it behind him. He never expected to be reliving the same disaster of a day, over and over... and over.<br><br>TV tropes page here:<br>http://tvtropes.org/pmwiki/pmwiki.php/FanFic/TheBestNightEver<br><br>Thanks to all the people who wrote the page and all the people who gave me a little wakeup call and comment to become aware of that fact! You can't see it, but you guys put a real smile on my face tonight.<br><br>Also, recently, extra thanks to RD Dash for giving TBNE a thorough editing. I've updated the fic accordingly (7.11.12)",
        reviews: [
            "It's a very good fic and was one of the first ones that I read. Time loop stories are my shit and I think anyone new to poni would like this to.",
            "I love \"Groundhog Day\" style fanfiction. The gradual evolution of the MC and their ascent is handled well. It makes you look at the Mane Six from interesting angles.",
            "Given it's (relative) short length and just how charming it is, [The Best Night Ever] is a fic I highly recommend. For those that don't know, it's essentially Groundhogs Day from the POV of Prince Blueblood during the Grand Galloping Gala at the end of season one."
        ],
        upVotes: 5245,
        downVotes: 83,
        rating: "T"
    },
    {
        name: "Gladiator",
        url: "https://www.fimfiction.net/story/144701/gladiator",
        image: "https://cdn-img.fimfiction.net/story/i0em-1432514744-144701-full",
        tags: [Tags.Adventure, Tags.Human, Tags.AU],
        length: 387426,
        recommends: 4,
        desc: "After escaping the Changeling gladiator arena at the cost of a friend's life, Equestria's lone human is attacked and befriended by Twilight Sparkle. This begins a long, strange, and confusing adventure to return home, and discover why he even arrived.<br><br>Complete, and edited twice... but If you see something I missed, I'd greatly appreciate it if you'd leave a comment.<br><br>Cover art made in Blender. ",
        reviews: [
            "Another strong showing for the dark fantasy and hie genres. But with an action focused story. The main character really carries this fic",
            "Starts out pretty edgy, but quickly settles down and turns into a normal adventure story. I also appreciated that the HiE isn't being shipped with anypony, for once.",
            "Its another solid HiE fic this time with bug horses. Its a great adaptation of changelings and the main character is a treat to read. most of all it doesn't overstay its welcome."
        ],
        upVotes: 1044,
        downVotes: 43,
        rating: "T"
    },
    {
        name: "Good Trooper Gilda",
        url: "https://www.fimfiction.net/story/418498/good-trooper-gilda",
        image: "https://cdn-img.fimfiction.net/story/xn5h-1538852030-418498-full",
        tags: [Tags.Comedy, Tags.Dark, Tags.SoL, Tags.AU],
        length: 106785,
        recommends: 4,
        desc: "Gilda only wanted the humble things in life. Cheap rent, copious bits, the respect of her peers, the occasional juicy field-mouse.<br><br>Being captured by the Equestrians and dragooned into the Territorials wasn't quite what she'd dreamed of, but at least the rent was free.<br><br>And the rats were nice and plump.",
        reviews: [
            "An interesting tale of conflict between cultures that takes the reader to the very borders of Equestria. Well written characters and background info. The constrast between this world and MLP shows how pain can change a pony.",
            "Cut some of the adventure, add back a lot of the war, and pile on the suck; Good Trooper Gilda is a masterpiece in battlefield literature. Always miserable, often funny, and surprisingly poignant, Good Trooper Gilda is a fine example of how to do an alternate universe right - show the reader the tantalizing details, let them fill in the rest. Excellent.",
            "9/10 'Good Trooper Gilda' is truly a treat, featuring an adventurous story, charming prose, lovable and hateable characters, all packaged in a smart, not overly long, and mostly self-contained bundle. I can only recommend it."
        ],
        upVotes: 644,
        downVotes: 9,
        rating: "T"
    },
    {
        name: "Sunny Skies All Day Long",
        url: "https://www.fimfiction.net/story/20685/sunny-skies-all-day-long",
        image: "https://cdn-img.fimfiction.net/story/5c7h-1432428695-20685-full",
        tags: [Tags.SoL],
        length: 8536,
        recommends: 4,
        desc: "Princess Celestia tires of constantly being surrounded by decorum, deference, and formality, and decides to take a day off from being Princess.  But visiting Ponyville incognito is harder than she expects.  Will she be able to fit in and make friends without blowing her cover?",
        reviews: [
            "One of the classic Celestia oneshots. Its SoL and short. What more could a new reader possibly want?",
            "Perhaps the archetypal SoL fic every other SoL fic is trying to replicate. One of the true fandom classics.",
            "Simple, comfy, and universally loved SoL featuring Celestia. You've already read it, but if you somehow hadn't, it's a staple."
        ],
        upVotes: 9313,
        downVotes: 144,
        rating: "E"
    },
    {
        name: "Would It Matter If I Was?",
        url: "https://www.fimfiction.net/story/289205/would-it-matter-if-i-was",
        image: "https://cdn-img.fimfiction.net/story/wlyn-1442195649-289205-full",
        tags: [Tags.SoL],
        length: 2220,
        recommends: 3,
        desc: "In the wake of the Canterlot Wedding, Fluttershy has to ask Twilight a very difficult question.<br><br>Now available in [url=https://www.deviantart.com/spaniard-kiwi/art/Would-it-matter-if-I-was-Spanish-translation-830105660]spanish![/url] Spinoff stories can be found in [url=https://www.fimfiction.net/group/209036/would-it-matter-if-i-made-this-group]Would It Matter If I Made This Group?[/url]<br><br>Now with a [url=http://tvtropes.org/pmwiki/pmwiki.php/Fanfic/WouldItMatterIfIWas]TVTropes page[/url].",
        reviews: [
            "Topically appropriate and extremely well written. A fic that has spawned dozens of copycats, not because it's two million words of escapism, but because it has the right premise.",
            "What makes a fic stand out? Sometimes all it takes is having just the right premise.",
            "[...] Recognizing the fact that this was a very early story of its genre and its pleasant prose and intriguing plot makes it easy for me to give it another +1."
        ],
        upVotes: 3299,
        downVotes: 223,
        rating: "E"
    },
    {
        name: "Exit Through Canterlot",
        url: "https://www.fimfiction.net/story/58321/exit-through-canterlot",
        image: "https://cdn-img.fimfiction.net/story/kxfk-1432452496-58321-full",
        tags: [Tags.SoL],
        length: 137539,
        recommends: 3,
        desc: "After the most important night of her career is ruined and its saboteurs not even so much as punished, Octavia's life changes. She begins to pursue a path that has never been seen before in Canterlot, where concertos and rhapsodies give way to controversy and rebellion.<br><br>A path where symphonies are composed with cans of spray paint.<br><br>Cover art used with permission by [url=http://lugiadriel14.deviantart.com]LuGiAdriel14[/url]",
        reviews: [
            "Remember how the mane six ruined the most important formal event of the year, and then got off the hook just like that? Well, Octavia does. When the most important night of her life is ruined, she decides to vent her anger, learn to express herself through a new medium of art, and become a rebellious anti-authority icon of Equestria.",
            "As far as alternate interpretations of background characters, this has to be one of my favourites. It's a really good character piece and an interesting look at what life in Canterlot could be regarding the arts and the class distinctions.",
            "I had forgotten about Exit through Canterlot, but this is a real page-turner, before you know it 130k words is already over"
        ],
        upVotes: 1963,
        downVotes: 49,
        rating: "E"
    },
    {
        name: "The Immortal Game",
        url: "https://www.fimfiction.net/story/1886/the-immortal-game",
        image: "https://cdn-img.fimfiction.net/story/zx9f-1432420757-1886-full",
        tags: [Tags.Adventure, Tags.Gore, Tags.Dark],
        length: 297261,
        recommends: 3,
        desc: "Long ago, in the magical land of Equestria, there lived a powerful King and his dark Queen. Immortal and ignorant, their end came at the hooves of their daughters, Celestia and Luna, who sought to build a better future for ponykind.<br><br>Now ponykind’s old gods have returned.<br><br>Twilight Sparkle is trapped inside her own mind, slave to a cruel and impulsive consciousness built from everything she is not. Powerless and voiceless, she must find a way to stop the being that calls itself Nihilus from destroying everything she holds dear.<br><br>Luna is tasked with assembling the remaining Elements of Harmony in hopes of freeing their leader. For if ponykind is to have any hope, it is in Twilight Sparkle. And if Twilight Sparkle is to have any hope, it is in her five friends.",
        reviews: [
            "I think its a really fun read and there are a lot of memorable moments that stuck with me, moments that make me go \"Fuck yea!\""
        ],
        upVotes: 3382,
        downVotes: 81,
        rating: "M"
    },
    {
        name: "The Moonstone Cup",
        url: "https://www.fimfiction.net/story/3378/the-moonstone-cup",
        image: "https://cdn-img.fimfiction.net/story/2bq6-1432421271-3378-full",
        tags: [Tags.Adventure],
        length: 61073,
        recommends: 3,
        desc: "Twilight is invited to Canterlot to compete with some of the greatest magicians in the world for the Moonstone Cup, a prestigious award for the most powerful and skillful magicians, unicorn and otherwise. Can she win? What sort of competition will she face?<br><br>Awesome cover image was taken from [url=http://noonebahtim.deviantart.com/art/Wise-Twilight-Sparkle-279941369]NoOneBahtim[/url]",
        reviews: [
            "The reason \"magic tournament\" fics don't exist anymore, it became the definition and killed the plot in the process. Adventurefags will like it and it's a blast from the past to boot.",
            "Unicorn Twilight and Trixie compete in a magic tournament held in Canterlot. A bit too anime for my liking but that makes it a good entry level adventure fic.",
            "A story that both made and killed the \"characters participate in a magic tournament\" plot because it checked off all the boxes and had a good Trixie/Twilight rivalry to boot."
        ],
        upVotes: 2977,
        downVotes: 45,
        rating: "E"
    },
    {
        name: "The Keepers of Discord",
        url: "https://www.fimfiction.net/story/25125/the-keepers-of-discord",
        image: "https://cdn-img.fimfiction.net/story/i9ft-1432431464-25125-full",
        tags: [Tags.Sad, Tags.SoL, Tags.AU],
        length: 11445,
        recommends: 3,
        desc: "You'd think that being trapped in stone would mean that, if nothing else, I could get some peace and quiet. Unfortunately, it seems that Celestia has other ideas. <br><br>She has appointed these ponies... these 'Keepers', as she calls them, to keep me entertained during my incarceration. <br><br>Honestly? I'd prefer the boredom.",
        reviews: [
            "Discord is trapped in stone. But worse than a long time alone is a long time with people that annoy you. I can find very few flaws in this fic, it's simple, well executed, and well worth reading.",
            "Fuck, that almost made me tear up. Gotta +1 it. Despite the story's age, it surprisingly feels fresher than several newer stories I've read.",
            "Short, bittersweet and well written. The author's take on Discord's character from pre-s3 era is really good."
        ],
        upVotes: 6424,
        downVotes: 89,
        rating: "T"
    },
    {
        name: "The Age of Wings and Steel",
        url: "https://www.fimfiction.net/story/13034/the-age-of-wings-and-steel",
        image: "https://cdn-img.fimfiction.net/story/4yrs-1432424657-13034-full",
        tags: [Tags.Adventure, Tags.Violence],
        length: 239666,
        recommends: 3,
        desc: "Three hundred years after the fall of Princess Luna, Equestria teeters on the brink of disaster. Bitter political infighting and power-hungry nobles threaten to tear the country apart in a bloody civil war, while in the south old enemies prepare to reclaim their ancient homeland from the ponies.<br><br>As Princess Celestia desperately strives to hold together her splintered nation, she sends a young pony on a quest to the northern lands that border Equestria in order to plead for aid against the threat of Grypha. This unlikely messenger is Rye Strudel, the flightless, magicless, half-breed son of a guard and a baker. Rye must do the impossible and unite the thanes of the north... for if he cannot, there may be no home to come back to.",
        reviews: [
            "Easy pick. Age of Wings and Steel is unquestionably the best adventure-war fic on the site. Great worldbuilding, good characterization, and surprisingly mature all the way through, it (and its sequel) are proof that grim stories don't have to be grimdark.",
            "8/10. Part warfic, part \"hero on an epic adventure,\" its Holy Roman Empire take on Equestria is unique, its characters and plot engaging, and its climax is the gold standard that has yet to be beaten by another warfic.",
            "One of the best warfics in the genre for its classic griffon invasion plot and fantastic climax, its only letdown is a not as interesting \"epic adventure\" the warfic has to share billing with. Still, both are great examples of their genres and the climex seamlessly blends the two together. A great fic to use to introduce new readers to both genres."
        ],
        upVotes: 429,
        downVotes: 7,
        rating: "T"
    },
    {
        name: "Friendship Is Magic - Extended Cut",
        url: "https://www.fimfiction.net/story/439970/friendship-is-magic-extended-cut",
        image: "https://cdn-img.fimfiction.net/story/y9yv-1586888226-439970-full",
        tags: [Tags.Adventure, Tags.Violence, Tags.Death, Tags.Mystery, Tags.AU],
        length: 112293,
        recommends: 3,
        desc: "Twilight Sparkle didn’t care about overseeing the Summer Sun Celebration in some podunk little town. She just wanted a chance to study the history of the Lunar Rebellions and maybe, just maybe, convince Celestia that her sister’s return was a real possibility. Now it’s a lot more than just a possibility, and one Canterlot egghead isn’t going to be able to take on Nightmare Moon and her army alone.<br><br> (Season 1, Episodes 1 and 2 of My Little Pony: Friendship is Magic rewritten and expanded as a mature fantasy adventure)",
        reviews: [
            "The best genre shifted retelling of the pilot out there, leaning heavily on the tropes of the dark fantasy genre while still capturing the heart of what made each of the characters great I cant recommend this enough.",
            "FIM:EC is a stellar retelling of the pilot. An adult oriented dark fantasy interpretation that really expands the world as to what could have been. The author managed to capture the quintessential essence of each of the main cast making them both recognizable but also fitting seamlessly into the new world.",
            "A retelling of the first two episodes, but with a more mature bent (not in that it involves sex and drugs) that has some rather excellent worldbuilding and seeing Twilight interact with the others as if she were a proper academic."
        ],
        upVotes: 137,
        downVotes: 4,
        rating: "T"
    },
    {
        name: "The Piano Man",
        url: "https://www.fimfiction.net/story/35169/the-piano-man",
        image: "https://cdn-img.fimfiction.net/story/jrj0-1432437818-35169-full",
        tags: [Tags.Dark, Tags.Human],
        length: 30127,
        recommends: 3,
        desc: "A pianist from Earth is home on a lonely Saturday, getting ready to enjoy his weekend, when he is suddenly summoned to Equestria - only to find himself being held captive by The Great and Powerful Trixie, who plans to use him as a piano-playing slave in her show.<br><br>[hr]<br>If you came here looking for the sequel, '[i]The Piano Man: Act II[/i]', it can be found [url=http://www.fimfiction.net/story/44381/The-Piano-Man%3A-Act-II]here.[/url]",
        reviews: [
            "A fic about perseverance and its another HiE fic that turns the genre aside a little bit by having it run opposed to the traditional main cast, and gives an excellent buildup to catharsis.",
            "A strong showing for the drama genre and HiE genre. A great message about perseverance and trixie is a fun villian to read.",
            "Another great story with a darker tone, very emotional and a good way to introduce how Human in Equestria can be done well."
        ],
        upVotes: 1258,
        downVotes: 48,
        rating: "T"
    },
    {
        name: "A Witch in Broad Daylight",
        url: "https://www.fimfiction.net/story/480844/a-witch-in-broad-daylight",
        image: "https://cdn-img.fimfiction.net/story/lleh-1627569515-480844-full",
        tags: [Tags.Comedy, Tags.Adventure, Tags.Horror, Tags.AU],
        length: 333263,
        recommends: 3,
        desc: "There’s no end to the monsters that lurk in the dark.<br><br>Ghosts, werewolves, mad scientists, cultists, mutants, zombies, vampires, aliens and more lie in wait in the dark corners of Equestria, terrorizing the night. But the most infamous and dangerous of them all is the legendary witch Twilight Sparkle, with a five hundred million bit bounty on her head.<br><br>Seeking fame and fortune, Rainbow Dash sets out to defeat the legendary witch and collect the massive reward. The one thing she wasn't counting on was Twilight being less evil than she expected.",
        reviews: [
            "It's a fun comedy featuring reasonable characters in a thoroughly unreasonable world, where, for example, a \"psycho zombie\" is a real thing that ponies have developed specific strategies for dealing with.",
            "A very nice AU fic focused on Rainbow and Twilight. Not much romance. If there is I think its intended to be ambiguous. Very few fics can run with an evil Twilight concept and still make it seem like Twilight. This fic nails Twilight's sociopathy while giving her a path to redemption through Rainbow Dash."
        ],
        upVotes: 880,
        downVotes: 16,
        rating: "T"
    },
    {
        name: "A Bug on a Stick",
        url: "https://www.fimfiction.net/story/396531/a-bug-on-a-stick",
        image: "https://cdn-img.fimfiction.net/story/zrpk-1514679323-396531-full",
        tags: [Tags.Comedy, Tags.SoL],
        length: 131211,
        recommends: 3,
        desc: "Celestia was a filly living on an isolated farm with her sister and harboring dreams of greatness. Chrysalis was a black goo poured out from a screaming wound in the walls of reality, with a weak grasp on the appropriate amount of fangs one should have. Friendship was inevitable.",
        reviews: [
            "It already deserves a recommendation for its excellent worldbuilding and great characterizations alone but, even more importantly, it's just an incredibly pleasant story to read. And yet you shouldn't let the tags fool you - this depiction of ancient Equestria can easily rival some of the best fantasy longfics out there. It strikes a perfect balance of cleverly expanding upon existing underutilized lore and adding its own where necessary. The pacing is good too, notably featuring a rare case of appropriately used timeskips."
        ],
        upVotes: 699,
        downVotes: 8,
        rating: "E"
    },
    {
        name: "The Enchanted Library",
        url: "https://www.fimfiction.net/story/240255/the-enchanted-library",
        image: "https://cdn-img.fimfiction.net/story/rkmy-1593759272-240255-full",
        tags: [Tags.Romance, Tags.Adventure, Tags.AU],
        length: 337147,
        recommends: 3,
        desc: "Everypony enjoys myths and ponytales, even if they know such things aren't real. Alicorns fighting against a spirit of chaos? An ancient princess trapped in a library under a tree, waiting to be found? Quite enchanting and fantastic tales yes, but nonetheless as fictional as Daring Do and other such stories. At least, that's what Rarity used to think.<br><br>She doesn't anymore.",
        reviews: [
            "The romance story that got me into romance. I put it off for years despite hearing great praise, because I just wasn't interested in reading a romance story. But when I did jump in, it pulled me in with both an excellent adventure - and a ship it actually made me care for. (For anyone screaming >homoships, it's not gay if it's a mare with a mare.) Monochromatic can REALLY write characters. An absolute page-turner."
        ],
        upVotes: 4317,
        downVotes: 62,
        rating: "T"
    },
    {
        name: "Fallout: Equestria",
        url: "https://www.fimfiction.net/story/119190/fallout-equestria",
        image: "https://cdn-img.fimfiction.net/story/fuca-1432496101-119190-full",
        tags: [Tags.Adventure, Tags.Gore, Tags.Dark, Tags.Crossover],
        length: 620295,
        recommends: 3,
        desc: "[i]Fallout.  With ponies! Set in an alternate future, one pony must learn to survive in a blasted, poisoned land... and possibly, with the aid of friends made along the way, bring new light into the darkness of post-apocalyptic Equestria. [/i]<br><br>[size=12][b]Author's note:[/b] This is the original [i]Fallout: Equestria[/i], uploaded to FIMfiction due to popular request.  The story is as identical as possible to its original publishing.  I am aware of the heated opinions surrounding this story, so I will be policing the comments section.  Posts that are rude or hostile will be deleted; trolls and members of hate-groups will be blocked.  My goal is to create a friendly, hospitable atmosphere for people to discuss the story.  [b]Warning: comments section may contain spoilers[/b].[/size]<br><br>Please enjoy the story.",
        reviews: [
            "Gateway drug. This got me into MLP in the first place. It does action really well, has awesome art, and good characters. The blend of the two worlds spawned a whole new fandom.",
            "It has flaws. Many. But, depending on how picky you are, it can still be a very enjoyable read. If you sit back and carefully pick apart the worldbuilding, yes, some aspects are stupid; and sure, at times characters act retarded. But most of the time, the story itself is still very fun and readable. I read it across 2021 and 2022, after ~8 years of reading horsewords, and I still enjoyed it - you just have to be willing to look past the occasional detail (and, specifically, the first couple of chapters, which are notoriously shitty in terms of characterising Littlepip).",
            "The main Fallout crossover fic. Dark and bleak. Hasn't aged very well, has blatant cases of video game logic. However, it's still a fun read, and it will open up your world to the many sidefics that it spawned."
        ],
        upVotes: 10475,
        downVotes: 295,
        rating: "M"
    },
    {
        name: "Off The Edge Of The Map",
        url: "https://www.fimfiction.net/story/480/off-the-edge-of-the-map",
        image: "https://cdn-img.fimfiction.net/story/2tt2-1432419369-480-full",
        tags: [Tags.Adventure, Tags.Romance],
        length: 34894,
        recommends: 3,
        desc: "When Rainbow Dash's newest trick backfires spectacularly, she and Fluttershy find themselves stranded in the middle of nowhere. Together, they'll have to survive and find their way back to Equestria and Ponyville...no matter how far the journey.<br><br>Now with a Spanish translation by [url=https://www.fimfiction.net/user/352294/SPANIARD+KIWI]SPANIARD KIWI[/url]: [url=https://www.deviantart.com/spaniard-kiwi/art/Apoteosis-1-3-857109863]https://www.deviantart.com/spaniard-kiwi/art/Apoteosis-1-3-857109863[/url]<br><br>(Originally submitted to Equestria Daily)<br>Art by [url=http://katisconfused.deviantart.com/?rnrd=6727]katwalk.[/url]",
        reviews: [
            "Ancient by fimfic standards, Off The Edge of The Map still is a great introduction to adventure fics today. While the writing style might feel a bit clunky at times, the fic offers stellar worldbulding and an interesting story. It's also very short for a complete adventure fic which makes recommending it that much easier. If you don't mind shipping canon characters the next books in the series are even better.",
            "Consider this a nomination for Daetrin. Common wisdom is that his stories improve in chronological order; hence Off the Edge of the Map is his weakest. Common wisdom is also that ALL of Daetrin's stories are excellent and you should read all of them (in chronological order, again).",
            "By far the best adventure fic I've read and yet it's only ~34k words long. The worldbuilding is great and both FS and RD are written incredibly well. Don't get discouraged by the romance tag if that's not your thing, it's so subtle you could easily miss it. The sequels are really good too however they're much heavier on the romance elements."
        ],
        upVotes: 2112,
        downVotes: 29,
        rating: "E"
    },
    {
        name: "Scion of Chaos",
        url: "https://www.fimfiction.net/story/19508/scion-of-chaos",
        image: "https://cdn-img.fimfiction.net/story/zk6p-1432427957-19508-full",
        tags: [Tags.Adventure],
        length: 70111,
        recommends: 3,
        desc: "Sweetie Belle is compelled to learn magic after Rarity promises to teach her the finer art of dressmaking, but only once the young filly has learned the basics of magic. However, learning magic comes with its own set of complications and bears an unforeseen gift that will change Sweetie Belle's life forever.",
        reviews: [
            "Cute Sweetie Belle adventure story with Discord. The author writes in an authentic way and I like fillies gaining phenomenal cosmic power. it was also a very good cute fic. I highly recommend this one. It also gives me S1 feels.",
            "Going on that small journey with Sweetie Belle and Discord, learning about magic, and the random dangers they face in the Everfree is so much fun. I love it to this day and I'm forever mad the sequel was never finished.",
            "Sweetie Belle starts taking magic classes with Twilight until shn starts listening a voice... A voice that shows her a brand new world, full of possibilities. She then leaves home on a quest to find the source of that voice, learning magic, bonding, and getting to know the dangers and mysteries that the wilderness holds."
        ],
        upVotes: 2001,
        downVotes: 27,
        rating: "E"
    },
    {
        name: "Taken for Granite",
        url: "https://www.fimfiction.net/story/44765/taken-for-granite",
        image: "https://cdn-img.fimfiction.net/story/9e6b-1432443867-44765-full",
        tags: [Tags.Romance, Tags.Comedy, Tags.Sad, Tags.Tragedy],
        length: 1094,
        recommends: 2,
        desc: "Tom and Bloomberg are two vastly different... entities... that immediately catch each other's eyes; alas, how swiftly things must fade.<br><br><br><br>...Why did I write this again?",
        reviews: [
            "8/10. A crackfic that's able to wring both absurdist humor and some poignant tragedy out of the ship it's created--tragedy which serves to enhance the humor that's needed for a crackfic to succeed.",
            "An extremely brief romance written about a boulder and a young apple sapling. The prose is flowery and the story is sweet, with an interesting look into the thoughts of inanimate objects. So short that there is no reason not to read it",
            "The best crackfic on the site. It takes a premise so absurd it's laughable but still manages to draw some emotion from you--which only leads to more laughing because of how absurd it is."
        ],
        upVotes: 67,
        downVotes: 6,
        rating: "E"
    },
    {
        name: "Statistics",
        url: "https://www.fimfiction.net/story/48108/statistics",
        image: "https://cdn-img.fimfiction.net/story/u24t-1432446050-48108-full",
        tags: [Tags.Sad],
        length: 1042,
        recommends: 2,
        desc: "Sometimes, all we need are a few stats to shed some light on a subject.<br>",
        reviews: [
            "Depression shopping list .Statistics is a short story in list form, listing amounts line by line. In this form it narrates the grief that Celestia went through after banishing Luna to the moon. Poignant and heartbreaking, the format of the story adds to the unthinkable amount of time and sorrow she went through. The story is a great telling of something that wasn't really touched on that much in the show, and is a wonderful quick read.",
            "'Statistics' might be the most original take on the story of the two Royal Sisters that I've seen in any pony media. The author created a fic that's truly original and with incredible emotional impact. It's only a 1000 words long and its style may not be for everyone but I'd still encourage everyone to at least give it a shot.",
            "Fuck it. I'm shilling my own fic. I'm still amazed at how simple numbers can create so much emotion. "
        ],
        upVotes: 1559,
        downVotes: 39,
        rating: "E"
    },
    {
        name: "A Nice Game of Chess",
        url: "https://www.fimfiction.net/story/459906/a-nice-game-of-chess",
        image: "https://cdn-img.fimfiction.net/story/51md-1580438852-459906-full",
        tags: [Tags.Drama, Tags.Death],
        length: 3722,
        recommends: 2,
        desc: "After dying in a train crash, Twilight finds herself offered a deal by the Reaper: a game of chess for her soul. Twilight accepts, but there's something off about the game. Something she can't put her hoof on.<br><br>But the answer to that question is just perfect for who she is.",
        reviews: [
            "This is not an exceptional fic. It is, however, an exceptionally well made *good* fic and for that it deserves a recommendation to everyone new to oneshots or fics in general.",
            "Twilight dies in a train crash and meets the Reaper, who offers her life back in exchange for winning at a game of chess. This is an inventive fic that is well written and expands on the lore of the show. Twilight speaks to the Reaper over the game, and gleans knowledge about some inner workings of the world. The ending is touching and satisfying, and the prose is fun. Absolutely worth a read.",
            "[A Nice Game of Chess] surprised me with how all-around good it was.  It's not revolutionary in any way (the opposite, in fact) but it's fairly interesting and nicely written with an above-average worldbuilding for a shortfic. There's nothing I can seriously criticize about it."
        ],
        upVotes: 751,
        downVotes: 4,
        rating: "E"
    },
    {
        name: "Biblical Monsters",
        url: "https://www.fimfiction.net/story/87619/biblical-monsters",
        image: "https://cdn-img.fimfiction.net/story/8yss-1432473203-87619-full",
        tags: [Tags.Dark, Tags.Death, Tags.Tragedy, Tags.Human],
        length: 10189,
        recommends: 2,
        desc: "At 3:15 AM, Adams woke me with a loud knock on my front door.<br>\"Put your boots on,\" he said when I answered. \"There's a biblical monster in my house.\"",
        reviews: [
            "People weren't lying, it's a really good fic. I don't remember the last time I've read a story with such a sublimely crafted atmosphere, pony or otherwise. The conflict feels believable, the OCs have sufficiently developed characters (a rare thing in a shortfic) and the final scenes are absolutely chilling. I'm by no means a horror expert but I liked that it didn't waste time on pointless descriptions like so many (bad) fics in the genre tend to do to artificially create a horror atmosphere. Biblical Monsters just throws you right into the action and provides details only when they're actually relevant. And yet the mood is probably this fic's biggest strength. It sucks you in and doesn't let go until the very end. Or probably a bit longer than that, the ending hits so hard that I had to take a quick walk outside to calm down.",
            "Overall: 10/10 This was a humbling read. The author has displayed how you can use just ten thousand words to shock your readers and depict a tragedy that feels realistic and human, without feeling cynical. Highly recommended.",
            "Background Pony often gets praised for its delightfully hopeless atmosphere. It's not necessarily wrong but Biblical Monsters manages to do outdo BP without resorting to purple prose or scenes that go nowhere. It's exquistely gloomy, characters are well-developed and their actions (as well as the final conflict) naturally follow from everything happening in the story. All of that in just 10k words."
        ],
        upVotes: 1853,
        downVotes: 166,
        rating: "T"
    },
    {
        name: "Reading Rainbow",
        url: "https://www.fimfiction.net/story/10624/reading-rainbow",
        image: "https://cdn-img.fimfiction.net/story/0v9y-1432423784-10624-full",
        tags: [Tags.Comedy, Tags.SoL],
        length: 7354,
        recommends: 2,
        desc: "When a freak reading accident causes Twilight to be admitted to the Ponyville hospital, Rainbow Dash is right by her side.  Compelled by a sense of duty and repayment, she takes it upon herself to cheer up her friend.",
        reviews: [
            "An accident leaves Twilight temporarily blind, and Rainbow Dash takes it to herself to ease her time in the hospital by reading to her. The story captures Dash and Twilight beautifully despite giving them only a few lines. The book Dash reads is also quite cute and endearing. There really isn't much to say about this one. It's sweet, short, and to the point. Good for heart and belly fuzzies.",
            "Prose is good and all but have you ever read a fic that features a fully complete 2500 words long poem? Really cute story and a near flawless execution - this is the peak of SoL oneshot genre. A definite must read for anyone."
        ],
        upVotes: 3984,
        downVotes: 67,
        rating: "E"
    },
    {
        name: "Eyes On You",
        url: "https://www.fimfiction.net/story/7531/eyes-on-you",
        image: "https://cdn-img.fimfiction.net/story/llx0-1432422705-7531-full",
        tags: [Tags.Romance],
        length: 148080,
        recommends: 2,
        desc: "One would think that the wounded Trixie would appreciate Twilight Sparkle taking her in to nurse her back to health. But for some ponies, leaning on someone else isn't so easy. Their crossing of paths sets them both on a journey that neither of them would've expected...",
        reviews: [
            "One day, Twilight hears a cry of help in the forest, when she goes to invesitgate, she founds a battered Trixie being attacked by Timberwolves. What follows is the birth of a strong friendship, and perhaps something more. But, why has Trixie returned to Ponyville? Well, she wants Twilight to be her partner in the Manehattan Magic Display, Equestria's most prestigious show magic expo. Overall, this is a great fic. The relationship between Trixie and Twilight feels natural, and the Display is a really interesting event with fun and creative events. If you like Twixie and Grand Tournaments, this is for you.",
            "One of the best romance fics, though there's a clear difference between the first and second halves it's still a pretty good story (and Celestia actually gives good advice when she shows up)",
            "Finally, [Eyes on You] is a slow burn romance with Twilight and Trixie where Trixie had gone back to Ponyville to get Twilight to be her partner in a huge magical competition in Manehatten. It's likely the best romance fic I've read."
        ],
        upVotes: 1235,
        downVotes: 30,
        rating: "E"
    },
    {
        name: "Carousel",
        url: "https://www.fimfiction.net/story/320477/carousel",
        image: "https://cdn-img.fimfiction.net/story/4hkf-1458419717-320477-full",
        tags: [Tags.Drama, Tags.Dark, Tags.Horror],
        length: 69392,
        recommends: 2,
        desc: "The Millennial Summer Sun Celebration is only a few years away, but Rarity’s fashion career seems to be ending before she can begin it. Now, she has one last chance to find a place for her talent.<br><br>But as she works to create the boutique of her dreams, a forgotten piece of Ponyville’s past is waking up. Secret memories lie forgotten in dusty basements, unrighted wrongs scratch at locked doors, and Rarity finds herself caught up in a history that may be doomed to repeat itself.<br><br>For although she is the first to set hoof in the Old Town Hall in thirty years, she can’t help but feel that something inside was waiting for her.<br><br>[hr]<br>A slow-burning, atmospheric horror.",
        reviews: [
            "9/10. Tired of Apple Bloom being chased by monsters or eldrich abominations killing everyone? Why not come to pre-S1 Ponyville and read with increasing dread as the tension builds and atmospheric horror mounts while Rarity moves into her house."
        ],
        upVotes: 250,
        downVotes: 6,
        rating: "T"
    },
    {
        name: "I Dream of Luna",
        url: "https://www.fimfiction.net/story/163879/i-dream-of-luna",
        image: "https://cdn-img.fimfiction.net/story/axkq-1432528851-163879-full",
        tags: [Tags.Romance, Tags.Adventure, Tags.Comedy, Tags.Human],
        length: 83761,
        recommends: 2,
        desc: "[ Rated [color=#be4343]mature[/color] for excessive language and humorous sexual dialog and situations. ]<br><br>Anon's got pony problems. Fluttershy's been stalking him, Twilight's trying to experiment on him, and he's been fighting sleep ever since he met Luna at a dinner party last week. The reclusive Princess of the Night has taken a somewhat inappropriate interest in him and has been invading his dreams! <br><br>Thanks to Luna's dreamwalking shenanigans, Anon now has to contend with doomsday meteors, horrendous creatures, and harrowing trials in addition to the growing herd of overly amorous mares plaguing him in his daily life. The line between dreams and reality begins to blur, leaving Ponyville's poor resident human desperate for a moment of peace and quiet!",
        reviews: [
            "It has stellar comedic sense and command of pacing. It also maintains a perfect balance of lighthearted adventure seasoned with serious emotional moments at all the perfect times. This makes the lighthearted parts of the story never feel overdone while also making the emotional scenes hit that much harder. It has a very good interesting characterization of Luna, even if it may not be a very typical characterization of her. I Dream of Luna is a story of fairly modest length which is easy to pick up and get invested in. It's a great read for just about anyone."
        ],
        upVotes: 2304,
        downVotes: 87,
        rating: "M"
    },
    {
        name: "Monsters",
        url: "https://www.fimfiction.net/story/169613/monsters",
        image: "https://cdn-img.fimfiction.net/story/tfef-1438341328-169613-full",
        tags: [Tags.Drama, Tags.Gore, Tags.Dark, Tags.Mystery],
        length: 115226,
        recommends: 2,
        desc: "Two decades after the banishment of Nightmare Moon, her shadow still lingers. Princess Celestia has been left to tend the Twin Thrones alone and protect us all from those who would see Equestria crumble. Our enemies take many forms: some would tear the world down with their claws, others with their smiles. They are monsters all the same.<br><br>I have had many names, and I have been many things. Today I am Swift Sweep, and I work for the Equestrian Bureau for State Security.",
        reviews: [
            "A dark , brooding atmosphere saturates the story of a former Night Guard struggling to stop a cult in an Equestria teetering on the brink of a full on dictatorship due to Celestia's mental collapse in the years following NMM. A great example of a darkfic for those new readers wanting to dip a toe in the murky waters.",
            "Monsters is a dark look into an Equestria that's still fresh off of Luna's banishment. It has its edgier moments, but it expands on what Luna's betrayal leashed upon the populace and gives us a secret service dedicated to working from the shadows to right those wrongs, so it never feels pointless and phoned in. It also does quite well in making the OCs sympathetic/enjoyable characters to follow along with."
        ],
        upVotes: 550,
        downVotes: 15,
        rating: "T"
    },
    {
        name: "Redheart's War",
        url: "https://www.fimfiction.net/story/464928/redhearts-war",
        image: "https://cdn-img.fimfiction.net/story/7fu7-1586078504-464928-full",
        tags: [Tags.Adventure, Tags.Drama, Tags.Gore, Tags.Violence],
        length: 46081,
        recommends: 2,
        desc: "A nurse has seen it all. A combat medic has seen even more.<br><br>Princess Celestia sends her elite Household Battalion—\"Celestia's Own\"—south, far beyond the borders of Equestria, to break the slave trade and to free the oppressed. Medic Redheart, a young rookie among the Guard's hardened veterans, is with her Battalion every step of the way. <br><br>She's never told anypony her story. Until now.",
        reviews: [
            "It is not a perfect story and arguably, due to the themes it handles and the way it handles it, it's very much not for everyone, but if you want a brutal depiction of war where spirits and bodies are broken, but ultimately the goodness and sense of duty prevails, I can easily recommend this story.",
            "All in all, I found this one an engrossing fic. Redheart herself sustains many injuries, and due to a good story stucture, and nice prose (which, while descriptive enough, never turned purple) you can feel for the poor mare, and root for her, and you worry about her, despite knowing she survives. Another thing that should be pointed out, is how well the fic is paced: it is only 46k words, yet tells a well-rounded story, which almost never felt rushed, or skipping over important details."
        ],
        upVotes: 400,
        downVotes: 12,
        rating: "T"
    },
    {
        name: "World of Colgates",
        url: "https://www.fimfiction.net/story/480334/world-of-colgates",
        image: "https://cdn-img.fimfiction.net/story/9bjn-1602997473-480334-full",
        tags: [Tags.Adventure, Tags.Comedy, Tags.Violence, Tags.SciFi],
        length: 14894,
        recommends: 2,
        desc: "Colgate is a pony of simple pleasures. She wakes up, goes to work, avoids whatever nonsense is plaguing the city of Ponyville today, and heads home, leaving better suited ponies to clean up the weekly mess.<br><br>Until one day she wakes up, and it is not tomorrow.<br><br>This begins a series of circumstances that will eventually culminate with a conversation with a star, a lifesaving mattress, several pieces of magical cutlery, a series of one-hit KOs, and a chase through the past and the future for the fate of all Equestria.<br><br>Just a normal Tuesday in Ponyville, even when the exact date is negotiable.",
        reviews: [
            "8/10 I'm willing to give this story a high score due to its clever time-travel shenanigans. 'World of Colgates' is a comfy and entertaining action-comedy that I can easily recommend for readers who want to smile, as long as they're okay with forgiving a few niggles in the logic. ",
            "A very good, extremely tight-written comedy. Not only is it an extremely enjoyable story to read through, it's a wonderful example of using setups and callbacks to great effect. It's all around the kind of thing that's well written enough it almost makes you envious, and it's one of the stories I come back to to remind myself of what the site is capable of producing.",
            "Though it's less surprising foreshadowing and more an absurdly tight writing package. It's a whole Chekhov's armory of details that all end up as pieces of the same puzzle. "
        ],
        upVotes: 129,
        downVotes: 1,
        rating: "T"
    },
    {
        name: "Lost Cities",
        url: "https://www.fimfiction.net/story/102166/lost-cities",
        image: "https://cdn-img.fimfiction.net/story/e1rz-1432483666-102166-full",
        tags: [Tags.Anthology],
        length: 11025,
        recommends: 2,
        desc: "North of Canterlot, in the far marches of Equestria near the border with the Griffon tribes, there is a mountain that flies.<br><br>West of Canterlot, beyond the Galloping Mountains and a desert painted in the pastel hues of a faded rainbow, a tower sits at the edge of the world.<br><br>South of Canterlot, past the Everfree forest and the desolate badlands, a city of gardens waits to be born.",
        reviews: [
            "Eerie and atmospheric glimpses of an Equestria lost to history. It really drives home how much room for invention the setting has.",
            "This isn't a story; it's a collection of historical pieces about headcanon places around Equestria, but it's written so exceptionally well I had a hard time believing that someone was willing to put in so much effort into pony. If you want to see a masterclass example of scene setting and descriptive writing, this is it.",
            "There's not a narrative, just atmospheric descriptions that give you tantalizing glimpses into history."
        ],
        upVotes: 1175,
        downVotes: 18,
        rating: "E"
    },
    {
        name: "The Glass Blower",
        url: "https://www.fimfiction.net/story/3228/the-glass-blower",
        image: "https://cdn-img.fimfiction.net/story/fmym-1432421215-3228-full",
        tags: [Tags.Romance, Tags.Dark],
        length: 10489,
        recommends: 2,
        desc: "She is as beautiful and graceful as the moon, and just as hard to reach. He is a young artist with much to learn about the world. When he accepts her challenge to create an artistic masterpiece, will he win her heart, or learn a terrible lesson in the nature of beauty and love?",
        reviews: [
            "The Glass Blower is a classic tale of distant admiration and unrequited love. The author doesn't just tell the story of this glass smiths attempts at courtship, he makes you part of it. A non-corporeal onlooker screaming at the injustice of it all.",
            "I've seen this one mentioned time and time again, so I finally caved and read it. It's a beautiful little fable and a nice tragedy, despite featuring none of the stereotypical things associated with the genre. Another easy +1.",
            "This fic is a masterpiece, and my description wouldn't stand up to what's inside."
        ],
        upVotes: 1153,
        downVotes: 25,
        rating: "E"
    },
    {
        name: "The One Who Got Away",
        url: "https://www.fimfiction.net/story/284135/the-one-who-got-away",
        image: "https://cdn-img.fimfiction.net/story/avbq-1440385624-284135-full",
        tags: [Tags.Romance, Tags.SoL],
        length: 22466,
        recommends: 2,
        desc: "When Gaberdine is awarded a noble title by Princess Celestia, he soon finds out that his new lands contain several surprises.  For starters, there is no land in his new barony.  Secondly, his new castle turns out to be a broken-down riverboat.  And third is… seaponies.<br><br>Baron Gaberdine has a lot to learn about his new barony.  And himself.<br><br>Fortunately, he has a very young teacher.",
        reviews: [
            "Just a nice little OC/OC romance, with no absurd drama or other nonsense. Top comfy.",
            "A quiet little Romance SoL. In the rare club of fics that have printed (immediately and sold out) at the Bronycon Bookstore, and for a reason.",
            "A very cozy read and doesn't drag itself out for too long and isn't just a flash in the pan so perfect reading for a calm weekend."
        ],
        upVotes: 1887,
        downVotes: 23,
        rating: "E"
    },
    {
        name: "Synthetic Bottled Sunlight",
        url: "https://www.fimfiction.net/story/303160/synthetic-bottled-sunlight",
        image: "https://cdn-img.fimfiction.net/story/0dfq-1618247099-303160-full",
        tags: [Tags.Romance, Tags.Drama, Tags.Gore, Tags.Profanity, Tags.Dark, Tags.AU],
        length: 242114,
        recommends: 2,
        desc: "Time after time, through chaos and through wars, Princess Celestia prevailed. <br><br>Of all the terrible forces she could have fallen to, Flim Flam Industry was the last one anypony had expected.",
        reviews: [
            "Changelings conquer Equestria, Sombra conquers Equestria, Evuuul anti-gays conquer Equestria (Rekindled Embers, maybe I should read that fic just so I can rant about it lol).  I haven't ever seen someone do a Flim and Flam conquering Equestria before. The unique premise is good and it continues to deliver upon it. I remember it fondly even though I stopped reading it when there weren't any new chapters (I usually binge read things).",
            "Very interesting fic about Celestia recovering and returning to society after being forced into a prison for years to make sunlight. "
        ],
        upVotes: 1104,
        downVotes: 41,
        rating: "T"
    },
    {
        name: "The Sun Whispers Your Name",
        url: "https://www.fimfiction.net/story/28840/the-sun-whispers-your-name",
        image: "https://cdn-img.fimfiction.net/story/l1kb-1432433874-28840-full",
        tags: [Tags.Adventure],
        length: 32094,
        recommends: 2,
        desc: "Princess Celestia lies unconscious without explanation… And the sun refuses to rise. Desperate, Luna calls upon her Sister’s faithful student for help in an effort to enter the Princess of the Sun’s mind through a dreamscape to find the cause of her mysterious coma.<br><br>But once they enter, finding themselves in a place of magic itself, a place where a pony’s fears, dreams and histories manifest themselves as worlds of epic proportions, are the two mares ready for what they find inside?<br><br>An action fantasy novella. <br>[url=http://www.equestriadaily.com/2012/06/story-sun-whispers-your-name.html]Featured on EqD![/url]",
        reviews: [
            "Almost a decade later 'The Sun Whispers Your Name' is still one of the few good Twilight and Luna stories that don't involve romance between the two. Despite being only 32k words long it manages to deliver a compelling adventure story that takes place in an equally interesting setting.",
            "The fic very closely focuses on Twilight and Luna, but it's not a tunafic, which might be a relief to those who are searching for interactions with these two that don't turn into romance. The story features exploration, action, some philosophical stuff, and a twist ending, although in retrospect, many would see it coming. All in all, it's commendable how many features of a good adventure story is crammed into this one, despite its relatively short length."
        ],
        upVotes: 615,
        downVotes: 22,
        rating: "E"
    },
    {
        name: "Whom the Princesses Would Destroy...",
        url: "https://www.fimfiction.net/story/54117/whom-the-princesses-would-destroy",
        image: "https://cdn-img.fimfiction.net/story/2itv-1432449880-54117-full",
        tags: [Tags.Comedy, Tags.SoL],
        length: 19758,
        recommends: 2,
        desc: "To Twilight Sparkle and Princess Celestia, it is a simple surprise visit to Canterlot. To the ponies of the Equestrian Civil Service, it is twenty-four hours of chaos, politics, weaponized dessert, politics, underhooved manipulation of media, politics, and things batrachian and tentacular. Who said bureaucracy isn't exciting?<br>",
        reviews: [
            "9/10. A comedy that plays with the underused Canterlot bureaucracy and is able to build up the SoL. Maybe not the most original blending, but one of the best executed. ",
            "Burecratic humor may not be everyone's cup of tea but it's at least something different for new readers who've grown bored of the same comedy oneshots with the same punchline endings.",
            "Bureaucracy can be so absurd that there's a lot you can laugh about. Especially with a 1000 years old princess that likes to cause chaos. A solid comedy whose main fault is that there isn't more of it."
        ],
        upVotes: 2903,
        downVotes: 43,
        rating: "T"
    },
    {
        name: "Five Hundred Little Murders",
        url: "https://www.fimfiction.net/story/126415/five-hundred-little-murders",
        image: "undefined",
        tags: [Tags.Sad, Tags.SoL],
        length: 10523,
        recommends: 2,
        desc: "Flitter doesn't like most ponies.  There's hardly anything in the world Flitter likes, very few which she can even remotely [i]tolerate[/i], and only a couple which she truly loves.  Fluttershy is [i]not[/i] in the last two categories.  Flitter sees Fluttershy as weak, and weakness disgusts her.  <br><br>But when you're trying to help someone you love, you'll look for help in a lot of places -- including the cottage of the weakest pony in the world.  <br><br>And for those willing to listen past their pain, it might be the place where they start to learn what true strength is.<br><br>(This story takes place about five moons before [b]Triptych[/b] and well after [b]On The Application...[/b]) <br><br>Part of the [b]Triptych Continuum[/b], which has its own [url=http://tvtropes.org/pmwiki/pmwiki.php/FanFic/TriptychContinuum]TVTropes page[/url] and [url=http://www.fimfiction.net/group/203805/estees-triptych-continuum]FIMFiction group[/url].",
        reviews: [
            "One of the better sad oneshots out there. The story features a fantastic characterization of Fluttershy that suits her perfectly. This is how you expand on canon personalities without going OOC.",
            "Its just an excellent estee fic. Does the monumental task of making you absolutely loath a character and then turning it around and having you feel sorry for them.",
            "I can confirm Gladiator is pretty good. It's not nearly as edgy as the description and first couple chapters make it sound. Nothing deep or surprising here, just a nice HiE adventure fic. There isn't even a romance subplot, which I honestly appreciated.",
            "[Five Hundred Little Murders] is a short and bittersweet story that manages to make its protagonist insufferable, and then turn around and make you care about her."
        ],
        upVotes: 1080,
        downVotes: 24,
        rating: "T"
    },
    {
        name: "Twilight Sparkle Makes a Cup of Tea",
        url: "https://www.fimfiction.net/story/58874/twilight-sparkle-makes-a-cup-of-tea",
        image: "https://cdn-img.fimfiction.net/story/etyu-1432452851-58874-full",
        tags: [Tags.Sad, Tags.SoL],
        length: 1671,
        recommends: 2,
        desc: "Early one morning, Twilight Sparkle gets up to make some tea. <br><br>Sometimes, a cup of tea is just a cup of tea. This is not one of those times. ",
        reviews: [
            "\"Twilight Sparkle Makes a Cup of Tea\" is roughly seventeen hundred words of excellent writing describing Twilight making some tea in the morning. Saying too much about the story would do it a disservice so I'll just say that despite its length, this story is incredibly effective at showing and evoking that certain kind of melancholy. Right now it's possibly one of my favorite short stories on the site. I'd recommend it to anyone who, at least sometimes, is feeling nostalgic. 10/10 ",
            "See, I really like this fic as well. The way Twilight's process is described is almost meditative. The memories are a bit vague, but that just helps to make it feel like nostalgia. And the ending while not exactly unexpected does crown the story well. I think things happen a bit too fast in the story, but not to an extent I'd seriously consider harming the experience.",
            "Short and sweet, this touching story narrates the intricate process of making tea in Twilight's POV while she remembers her time with Celestia. It focuses on the relationship between young Twilight and Celestia, as well as the ancient lifespan of the princess. The story switches back and forth between the narration of a step in the tea making process and Twilights memories of Celestia making tea and going over memories, giving an interesting juxtaposition between the past and present."
        ],
        upVotes: 1520,
        downVotes: 30,
        rating: "E"
    },
    {
        name: "Triptych",
        url: "https://www.fimfiction.net/story/101769/triptych",
        image: "https://cdn-img.fimfiction.net/story/4ta8-1648057715-101769-full",
        tags: [Tags.Adventure, Tags.Mystery],
        length: 505156,
        recommends: 2,
        desc: "For a thousand years, there was just Celestia.  Then Cadance appeared, Luna returned -- and now Twilight has ascended.  There are ponies who are very curious about just what happened, why -- and how.  Especially the how.  Twilight herself is on that list, a freshly-minted princess with far more questions than answers, about to face a brand new one:  what truly makes an alicorn?<br><br>And what happens if it goes wrong?  <br><br>(Part of the [b]Triptych Continuum[/b], which has its own [url=http://tvtropes.org/pmwiki/pmwiki.php/FanFic/TriptychContinuum]TVTropes page[/url] and [url=http://www.fimfiction.net/group/203805/estees-triptych-continuum]FIMFiction group[/url].  New members and trope edits welcome.)<br><br>Now with [url=https://www.patreon.com/estee?ty=h&alert=1]author Patreon[/url] and [url=https://ko-fi.com/H2H46PPO]Ko-Fi[/url] pages.<br><br>Cover art by [url=https://www.deviantart.com/harwicks-art]Harwick[/url].",
        reviews: [
            "I am an unmitigated Triptych apologist, and I don't care. Much can be said about ol estavo adolphus, but it is my opinion that his magnum opus is an extremely solid piece of fiction. It has problems, of course: it's huge, for one, although I think that it does generally manage to stay at a decent clip - it's overstuffed, although not impossibly so, and much of the luxuriant prose is directed well at establishing the oppressive setting. But if you can get around that, you'll find an extremely compelling piece of truly transformative fiction that really grapples with some core concepts of the show in a thoughtful way that always seems to make you want just a little more. It's not for everyone, but I think it is for a lot of people, and it's definitely worth a shot.",
            "I thought it was good, if a bit full of purple prose at times. It explored racial stuff in an interesting way. I don't think Estee topped it with any of his other fics. I'm still seething over the fact the he stopped writing the sequel to focus on his slow paced monster girl centaur anime story. ",
            "This is the fic Estee is known for. Triptych has very deep lore and is set in its own triptych-verse, which has more realistic/dark interpretation of Equestria (where, notably, earth ponies are not actually useless).  This is a fic where you will find full-fledged, lifelike characters with actual beliefs and motives. The villains are not just cartoon villains, they have *purpose* and *reasons* for doing what they do, twisted as they may be."
        ],
        upVotes: 1066,
        downVotes: 59,
        rating: "T"
    },
    {
        name: "Empty Horizons",
        url: "https://www.fimfiction.net/story/316852/empty-horizons",
        image: "https://cdn-img.fimfiction.net/story/vr9i-1573379955-316852-full",
        tags: [Tags.Adventure, Tags.Gore, Tags.Violence, Tags.SciFi, Tags.AU],
        length: 185696,
        recommends: 2,
        desc: "The surface isn't safe anymore.<br><br>In the ruined depths of Canterlot, a team of brave salvagers discover six mares, long forgotten but miraculously preserved. Though these mares cannot remember what happened to their world, they possess powerful magic that hasn't been seen for centuries.<br><br>Now the Elements of Harmony are thrust headlong into a world beyond recognition. Twilight and her friends must dive into the sunken remains of history to determine what happened, but Equestria isn't the harmonious land it once was. Before they can focus wholly on the past, they may first have to survive the present.<br><br>It isn't going to be easy.",
        reviews: [
            "Empty Horizon and it's sequel are both very good. I don't know if there are any other comparable adventure fics that have been written in the past few years. Goldenwing is also based and I like his liking of airships.",
            "Amazing setting, great and loveable characters who you can't help but care about. A plot full of intertwined intrigues and mysteries. Supplements that further broaden the scope of the world... and a few dumb choices that forbid me from giving it a perfect score. 'Empty Horizons' is a quintessential read to anyone who likes long adventure stories that don't consider its readers dumb and for those who like to be invested in a science-fantasy world that feels logical.",
            "A solid character driven epic the covers the mane six as they get displaced out of time in a water world equestria with feudalism and limited magic. While the worldbuilding leaves something to be desired as well as how the fic intends to resolve its main conflict without invalidating all its events its still a great option"
        ],
        upVotes: 1273,
        downVotes: 34,
        rating: "T"
    },
    {
        name: "What a Strange Little Colt",
        url: "https://www.fimfiction.net/story/478316/what-a-strange-little-colt",
        image: "https://cdn-img.fimfiction.net/story/krpa-1615448803-478316-full",
        tags: [Tags.Drama, Tags.Death, Tags.Profanity, Tags.SoL, Tags.Human],
        length: 105064,
        recommends: 2,
        desc: "Rainbow Dash's morning was pretty much ruined.<br>She tripped getting out of bed and landed flat on her face, giving herself an aching muzzle.<br>She forgot to buy her favorite brand of hay flakes at the store yesterday and had to eat plain toast for breakfast.<br>She found out she had to pull double-duty today [i]and[/i] tomorrow on the weather patrol.<br>Oh, and she found a nearly-dead foal, broken and bleeding at the edge of Ponyville.<br><br>The rest of her day became a whirlpool of stress and worry but the colt woke up, thank Celestia.<br>Something's not right, though. Nopony can find his parents, he's not in the registers, and there's an unsettling look in his eye...",
        reviews: [
            "A unique twist on the traditional HiE fic this one covers a suspenseful mystery as the main cast tries to uncover the secrets of the titular character. It also has stellar Rainbow Dash characterization and her performance is a big reason to check it out."
        ],
        upVotes: 2611,
        downVotes: 41,
        rating: "T"
    },
    {
        name: "Blueblood: Hero of Equestria",
        url: "https://www.fimfiction.net/story/55377/blueblood-hero-of-equestria",
        image: "https://cdn-img.fimfiction.net/story/w3zz-1432450589-55377-full",
        tags: [Tags.Adventure, Tags.Drama, Tags.Gore, Tags.Violence, Tags.Death],
        length: 419164,
        recommends: 2,
        desc: "In the aftermath of the Changeling incursion of Canterlot during the marriage of Shining Armour and Princess Mi Amore Cadenza, Equestria gears itself for war against the Changeling menace.  Against a foe that can take the shape of anypony, assume their life, and undermine Equestria from within, the Royal Pony Sisters create a new institution to monitor their Royal Guard for any Changeling corruption, cowardice, and incompetence: the Commissariat.  As total war rages across the land one hero stands out above the rest; Commissar Blueblood, Hero of Equestria.  Or at least that's what the propaganda says.  The truth, as ever, is far more complex, as the esteemed Blueblood is merely looking for an easy and sedate life.  Unfortunately, fate has a habit of throwing him into increasingly dangerous and suicidal missions, which he must survive with a combination of self-preservation, lying, and sheer blind luck, even if doing so only fuels his soaring reputation!",
        reviews: [
            "A Blueblood-centric warfic with great humor, one of the few fics that plays Twilight/Blueblood romance well without it coming across as a crackship, and the slightly darker tone and stellar worldbuilding makes it real easy to get and then stay invested in it",
            "A dark comedy that takes off at the canterlot wedding putting Blueblood in the unique situation where the safest way to be a coward is to do the dirty business of being a reluctant imposter syndrome hero. It also manages to keep some of the tone of the show while remaining dark but not grinders. "
        ],
        upVotes: 834,
        downVotes: 27,
        rating: "T"
    },
    {
        name: "Sunrise",
        url: "https://www.fimfiction.net/story/498024/sunrise",
        image: "https://cdn-img.fimfiction.net/story/6zhj-1625079300-498024-full",
        tags: [Tags.Adventure, Tags.Drama],
        length: 97598,
        recommends: 2,
        desc: "For Celestia's entire life, and time immemorial before, ponies have lived in three tribes. The magical Unicorn Kingdom in the far north moves the sun and the moon, the hard-working earth ponies grow food, and the proud pegasi of the Cloud Empire control the weather. They coexist out of necessity in a delicate balance of trade, although they have little trust or friendship for each other.<br><br>But now, the North is getting colder. Crops are failing, and the balance is crumbling. In the midst of the world's freezing, a sinister plan unfolds, spelling further disaster. Everything hangs on the precipice of catastrophe.<br><br>All Celestia ever really wanted was to be assigned to work on the sun control team, but her world needs heroes – before it's too late.",
        reviews: [
            "This fic, although tagged as adventure, could easily be tagged as a political thriller as well. The machinations the Sisters get into during the course of the story get deeper and deeper, and the more they know, the more they realize they might be just pawns in a much bigger game thanthemselves. But they go along with Clover's plan anyway, because they prioritize the greater good, that is having a pony realm where all kinds of ponies are free and equal.",
            "A rather excellent telling of the truth behind Hearth's Warming with Celestia and Luna as two young unicorns. If you're the kind of person that just absolutely hates season 9 then you can skip the epilogue."
        ],
        upVotes: 150,
        downVotes: 7,
        rating: "T"
    },
    {
        name: "To Perytonia",
        url: "https://www.fimfiction.net/story/383344/to-perytonia",
        image: "https://cdn-img.fimfiction.net/story/bqvv-1503427318-383344-full",
        tags: [Tags.Romance, Tags.Adventure],
        length: 554079,
        recommends: 2,
        desc: "By royal request, Rainbow Dash, Fluttershy and Rarity travel to far-off Perytonia to establish ties between Equestria and a strange new people.<br><br>Plunged deep into an alien culture with its own history, understanding the native peryton is only part of the challenge. As Rainbow Dash discovers, navigating her own relationship with her oldest friend may be harder still.<br><br>A season two story.",
        reviews: [
            "This fic is the very definition of a well executed Adventure story. The worldbuilding is top notch, the cultures it explores are all interesting, and while the plot is a little contrived at times, it stays engaging and exciting the whole way through. Its main flaws are with some of the characterization, some people find the romance parts pretty hit or miss. But as a Journey into a distant land, it's one of the best fics out there.",
            "A story about stories. I can probably best summarise To Perytonia as a comfy adventure. The story essentially focuses on the characters of Fluttershy, Dash and Rarity as they journey through an extremely foreign and alien land, tring to get to know the unfamiliar culture and understand it through the lens of their Equestrian upbringing.",
            "What the characters don't necessarily have, the world-building and exploration more than makes up for. Excellent adventure by a very clever author."
        ],
        upVotes: 359,
        downVotes: 12,
        rating: "T"
    },
    {
        name: "Sleepless",
        url: "https://www.fimfiction.net/story/193313/sleepless",
        image: "https://cdn-img.fimfiction.net/story/pb47-1432568689-193313-full",
        tags: [Tags.Gore, Tags.Dark, Tags.Horror, Tags.Tragedy],
        length: 36705,
        recommends: 1,
        desc: "Strange things happen in Ponyville. Foals start to disappear; their parents and siblings, struck by grief, will resort to every mean to find the cause. Some of them blame timberwolves; some blame the zebra living in the forest. Some of them even blame their fellow ponies. None of them, however, suspects a little filly suffering from insomnia...",
        reviews: [
            "Sleepless is a psychological horror fic. What it does really well is conveying the feeling of \"oh fuck, this can't be happening.\" It makes you feel like you just fucked up, and has you hope that somehow, everything will be okay. The mystery behind the murders keeps you on the edge of your seat as well. While it's not hard to figure out what might be going on, it's the fine details that have you hoping you're wrong. It's this constant battle of hope and despair that really keeps you on the edge of your seat.",
            "One of my recent reads and I absolutely loved it. Very angsty, the horror elements hit hard, and it made me very sad. If you're only gonna take one rec from this, make it this.",
            "A dark thriller and tragedy. Expect feels and chills."
        ],
        upVotes: 285,
        downVotes: 10,
        rating: "T"
    },
    {
        name: "Sun Princess",
        url: "https://www.fimfiction.net/story/118727/sun-princess",
        image: "https://cdn-img.fimfiction.net/story/2lcj-1432495771-118727-full",
        tags: [Tags.Sad, Tags.SoL],
        length: 1709,
        recommends: 2,
        desc: "In the final days of her life, an exceptionally faithful student muses on the subject of her perfect and immortal mentor Applejack.",
        reviews: [
            "8/10. Oneshots come and go and are easily forgotten, but the completely unique POV and perspective employed in it is one that I still think about from time to time, even nearly a decade after reading it. If that's not the mark of a good oneshot, then what is?",
            "A little manipulative for its attempts to tug at a pet owner's heartstrings, it still has a very unique premise and is honestly one of the only oneshots that I still think about from time to time. A great example for those new readers wanting a oneshot that isn't forgotten ten minutes after reading, like so many are.",
            "Sun Princess is kind of like the Amadeus of its genre of fics. There are no other famous movies about Mozart because the one we have is good enough for those too. And Sun Princess is THE sad pet death fic. But what makes it so good isn't how sad it is or how much it makes you cry or that kind of crap, it's how earnest it is. It plays the concept straight, it's competently written, but it doesn't get 'cheap' with the sadness."
        ],
        upVotes: 3127,
        downVotes: 39,
        rating: "E"
    }
];
// Ultimately this went nowhere. I originally wanted to include a different section showcasing the
// more "controversial" nominations, but I decided to not push it too hard after reactions were very
// mixed.
// Still, since I've already done the work, here they are.
/*
const controversial: Array<iFanfic> = [
    {
        name: "Fallout: Equestria - Project Horizons",
        url: "https://www.fimfiction.net/story/208056/fallout-equestria-project-horizons",
        image: "https://cdn-img.fimfiction.net/story/0xm9-1441146045-208056-full",

        genre: [Tags.Adventure],
        tags: [Tags.Sex, Tags.Gore, Tags.Tragedy, Tags.Crossover],
        length: 1780334,
        recommends: 5,

        desc: "Blackjack, an incompetent security mare from the dystopian Stable 99, suddenly has her monotonous life turned upside down when the stable is invaded by vicious raiders. Blackjack flees the stable with EC-1101, with the wasteland in hot pursuit.",

        upVotes: 3388,
        downVotes: 214,
        rating: "M",
    },

    {
        name: "Daring Do and the Hand of Doom",
        url: "https://www.fimfiction.net/story/413489/daring-do-and-the-hand-of-doom",
        image: "https://cdn-img.fimfiction.net/story/zcyb-1530675046-413489-full",

        genre: [Tags.Adventure],
        tags: [Tags.Death, Tags.Violence],
        length: 267333,
        recommends: 7,

        desc: "Daring Do quests for a legendary artifact of unusual provenance...and unusual danger.",

        reviews: [
            "'Daring Do and the Hand of Doom' is an adventure story, one of the few on the site I'd earnestly call \"good\". Where it excels is in how it uses the ponies. On the surface, everything the ponies touch is cute and cuddly. Instead of a whore house, the main villain drops by a snuggling den. Instead of an opioid parlor, its a salt bar. When one of the main antagonists implies that the hired mercenaries kill Daring, they're all appalled, ponies don't kill after all. But just under the safe veneer of cuddly lurks a world ready and willing to chew them up and spit them out at a moment's notice. A juxtaposition I don't think I've seen done as well in any other fimfic. The whole story focus' on an aging Daring, seeking out an artifact of eldritch power. I don't want to go into more detail as to avoid spoilers, but again, this is probably the best adventure fic on the site.",
            "A heartwarming adventure story with great plot, writing, characters and worldbuilding. Despite its teen rating there's nothing weird or objectionable you'd find in it and is no more violent then, say for example the original Ben 10. I wholeheartedly suggest this.",
            "Strong characters, good worldbuilding, really captures classic Indiana Jones feel. Great for all ages and theres no weird tranny,gay,/pol/ shit so its fairly timeless."
        ],

        upVotes: 54,
        downVotes: 1,
        rating: "T",
    },
]
*/
/**
 * This list contains the single nominations. Because I didn't bother to rip these properly, it's
 * merely an array of string-URL pairs that we iterate over.
 */
export const singleNominations = [
    // RIPPER
    /*
        const ids = [];
        const promises = ids.map(id => fetch("https://www.fimfiction.net/story/" + id).then(r => r.text()))
        
        const template = (title, url, tags) => `["${title}", new URL("${url}"), [${tags.map(t => "\""+t+"\"").join(",")}]],\n`
        
        let out = ""
        
        const parser = new DOMParser()
        
        Promise.all(promises).then(p => {
            
                    for (let i = 0; i < p.length; i++) {
                let [id, elem] = [ids[i], p[i]]
            
            const body = parser.parseFromString(elem, "text/html");
            const tags = [...body.querySelectorAll(".story_content_box .story-tags li")].map(li => li.innerText)
            const title = body.querySelector(".story_name").innerText
            const url = "https://www.fimfiction.net/story/" + id
            
                        out += template(title, url, tags)
            }
    
                console.log(out)
        })
    */
    ["A Ballad of Eeyup and Nope", new URL("https://www.fimfiction.net/story/53269"), [Tags.SoL]],
    ["A Once and Future Darkness", new URL("https://www.fimfiction.net/story/289892"), [Tags.Sex, Tags.Dark, Tags.SoL]],
    ["A Perfect World", new URL("https://www.fimfiction.net/story/500326"), [Tags.Drama, Tags.Sad, Tags.AU]],
    ["A Taste of the Good Life", new URL("https://www.fimfiction.net/story/134645"), [Tags.Romance, Tags.SoL]],
    ["Alarm Clock", new URL("https://www.fimfiction.net/story/56774"), [Tags.Adventure, Tags.SciFi]],
    ["Allegrezza", new URL("https://www.fimfiction.net/story/2365"), [Tags.Romance, Tags.Comedy, Tags.SoL]],
    ["An Academic Visit", new URL("https://www.fimfiction.net/story/244611"), [Tags.Human]],
    ["Anthropology", new URL("https://www.fimfiction.net/story/4656"), [Tags.Adventure, Tags.Comedy, Tags.SoL, Tags.Human]],
    ["Before the Storm: The Rise of Firefly", new URL("https://www.fimfiction.net/story/281029"), [Tags.Gore, Tags.Dark, Tags.Adventure, Tags.AU]],
    ["Blink", new URL("https://www.fimfiction.net/story/341279"), [Tags.Violence, Tags.Death, Tags.Dark, Tags.Horror]],
    ["Can I sleep with you tonight?", new URL("https://www.fimfiction.net/story/506047"), [Tags.SoL]],
    ["Cartography of War", new URL("https://www.fimfiction.net/story/171675"), [Tags.Adventure]],
    ["Celestia's Rocket Adventures", new URL("https://www.fimfiction.net/story/271498"), [Tags.Adventure, Tags.Comedy, Tags.Random, Tags.Crossover, Tags.Human]],
    ["Changeling Heart and the New Moon", new URL("https://www.fimfiction.net/story/25694"), [Tags.Dark, Tags.Adventure]],
    ["Coming Home", new URL("https://www.fimfiction.net/story/301126"), [Tags.Adventure, Tags.Drama]],
    ["Contraptionology!", new URL("https://www.fimfiction.net/story/14777"), [Tags.Adventure, Tags.Comedy]],
    ["Controlling Your Desires", new URL("https://www.fimfiction.net/story/395107"), [Tags.Sex, Tags.Romance]],
    ["Crisis on Two Equestrias", new URL("https://www.fimfiction.net/story/92300"), [Tags.Adventure]],
    ["Cutie Mark Crusaders and the Arena of Politics", new URL("https://www.fimfiction.net/story/506456"), [Tags.Comedy]],
    ["Dissonance: A Hidden World", new URL("https://www.fimfiction.net/story/435265"), [Tags.Violence, Tags.Death, Tags.Dark, Tags.Adventure, Tags.Mystery, Tags.AU]],
    ["Equestria Girls: A Fairly Odd Friendship", new URL("https://www.fimfiction.net/story/447335"), [Tags.Adventure, Tags.Comedy, Tags.Drama, Tags.Crossover, Tags.Human, Tags.AU]],
    ["Equestria 485,000", new URL("https://www.fimfiction.net/story/385770"), [Tags.Gore, Tags.Dark, Tags.Adventure, Tags.SciFi]],
    ["Faith and Doubt", new URL("https://www.fimfiction.net/story/51867"), [Tags.Dark]],
    ["Fallout: Equestria - Murky Number Seven", new URL("https://www.fimfiction.net/story/47300"), [Tags.Gore, Tags.Dark, Tags.Adventure, Tags.Crossover]],
    ["Filling Space", new URL("https://www.fimfiction.net/story/310807"), [Tags.Romance, Tags.SoL]],
    ["Foal of the Forest", new URL("https://www.fimfiction.net/story/116344"), [Tags.SoL]],
    ["Hard Reset", new URL("https://www.fimfiction.net/story/67362"), [Tags.Dark, Tags.Adventure]],
    ["Hearts on the Table", new URL("https://www.fimfiction.net/story/452774"), [Tags.Romance, Tags.Drama, Tags.SoL]],
    ["How to Remove a Unicorn Tooth", new URL("https://www.fimfiction.net/story/72096"), [Tags.SoL]],
    ["Injuring Eternity", new URL("https://www.fimfiction.net/story/167615"), [Tags.Romance, Tags.Sad]],
    ["Journey with a Batpony", new URL("https://www.fimfiction.net/story/204303"), [Tags.Romance, Tags.Adventure]],
    ["Lines and Webs", new URL("https://www.fimfiction.net/story/37820"), [Tags.Romance, Tags.Adventure, Tags.Sad, Tags.AU]],
    ["Lost Time", new URL("https://www.fimfiction.net/story/304593"), [Tags.Romance, Tags.Drama]],
    ["Magical Mystery Oops", new URL("https://www.fimfiction.net/story/249782"), [Tags.Romance, Tags.Comedy, Tags.SoL]],
    ["Moonshine", new URL("https://www.fimfiction.net/story/290546"), [Tags.Sex, Tags.Profanity, Tags.Romance, Tags.Adventure, Tags.Human, Tags.AU]],
    ["On a Cross and Arrow", new URL("https://www.fimfiction.net/story/755"), [Tags.Romance, Tags.Adventure, Tags.Comedy]],
    ["Princess Celestia Gets Mugged", new URL("https://www.fimfiction.net/story/99602"), [Tags.Comedy, Tags.SoL]],
    ["Princess Celestia: The Changeling Queen", new URL("https://www.fimfiction.net/story/82748"), [Tags.Adventure, Tags.Drama, Tags.AU]],
    ["Project Sunflower: Harmony", new URL("https://www.fimfiction.net/story/177431"), [Tags.Adventure, Tags.Human, Tags.AU]],
    ["Romance Reports", new URL("https://www.fimfiction.net/story/1422"), [Tags.Sex, Tags.Romance]],
    ["School Daze", new URL("https://www.fimfiction.net/story/2432"), [Tags.Romance, Tags.Comedy, Tags.SoL]],
    ["Sharing the Night", new URL("https://www.fimfiction.net/story/16375"), [Tags.Romance, Tags.Drama]],
    ["Stardust", new URL("https://www.fimfiction.net/story/100455"), [Tags.Gore, Tags.Dark, Tags.Crossover, Tags.Human]],
    ["Starlight Over Detrot: A Noir Tale", new URL("https://www.fimfiction.net/story/34706"), [Tags.Dark, Tags.Adventure, Tags.Mystery]],
    ["Sweetie Bot - A Heart's Warming Tale", new URL("https://www.fimfiction.net/story/233487"), [Tags.Gore, Tags.Dark, Tags.Sad, Tags.SciFi]],
    ["The Book of Might Have Beens", new URL("https://www.fimfiction.net/story/411078"), [Tags.SoL]],
    ["The Bug in The Cave", new URL("https://www.fimfiction.net/story/455858"), [Tags.Violence, Tags.Drama, Tags.SoL]],
    ["The Celestia Code", new URL("https://www.fimfiction.net/story/141549"), [Tags.Adventure, Tags.Mystery, Tags.AU]],
    ["The Changeling of the Guard", new URL("https://www.fimfiction.net/story/174129"), [Tags.Adventure, Tags.Comedy]],
    ["The Games We Play", new URL("https://www.fimfiction.net/story/3479"), [Tags.Romance, Tags.Dark, Tags.Sad, Tags.SoL]],
    ["The Good, the Bad and the Unfriendly", new URL("https://www.fimfiction.net/story/486744"), [Tags.Violence, Tags.Adventure, Tags.Anthology, Tags.Human, Tags.AU]],
    ["The Mare Who Once Lived on the Moon", new URL("https://www.fimfiction.net/story/247031"), [Tags.Romance, Tags.SciFi, Tags.SoL]],
    ["The Monster Below", new URL("https://www.fimfiction.net/story/76931"), [Tags.Gore, Tags.Violence, Tags.Drama, Tags.SciFi, Tags.Tragedy]],
    ["The Sister Sidestep: Scootaloo", new URL("https://www.fimfiction.net/story/483305"), [Tags.SoL]],
    ["The Tower of the Fallen Star", new URL("https://www.fimfiction.net/story/489858"), [Tags.Sex, Tags.Gore, Tags.Violence, Tags.Death, Tags.Adventure]],
    ["The Virgin Princess", new URL("https://www.fimfiction.net/story/437468"), [Tags.Dark, Tags.Drama, Tags.SoL]],
    ["The Youth in the Garden", new URL("https://www.fimfiction.net/story/50795"), [Tags.Gore, Tags.Sad, Tags.Human]],
    ["Through the Well of Pirene", new URL("https://www.fimfiction.net/story/73404"), [Tags.Adventure, Tags.Human]],
    ["Trouble in Tiatarta", new URL("https://www.fimfiction.net/story/450660"), [Tags.Romance, Tags.Adventure, Tags.AU]],
    ["Twice as Bright", new URL("https://www.fimfiction.net/story/84903"), [Tags.Romance, Tags.Comedy]],
    ["Upheaval: Breaking Point", new URL("https://www.fimfiction.net/story/10157"), [Tags.Gore, Tags.Romance, Tags.Dark, Tags.Adventure]],
    ["Waxing", new URL("https://www.fimfiction.net/story/462689"), [Tags.Violence, Tags.Profanity, Tags.Romance, Tags.Comedy, Tags.Human]],
    ["White Box", new URL("https://www.fimfiction.net/story/20116"), [Tags.Tragedy]],
    ["Yours Truly", new URL("https://www.fimfiction.net/story/22831"), [Tags.Romance, Tags.Sad]],
];
