/**
 * An enum representing the genres used by the stories on the list. The difference between genres
 * and tags is completely arbitrary, I just went with something that made sense to me.
 */
/*
export enum Genre {
    Romance = "Romance",
    Comedy = "Comedy",
    Adventure = "Adventure",
    Drama = "Drama"
}
*/

/**
 * An enum representing all the tags the stories on the list use.
 */
export enum Tags {
    Random = "Random",
    Horror = "Horror",
    Dark = "Dark",
    Sad = "Sad",
    Tragedy = "Tragedy",
    Crossover = "Crossover",
    Human = "Human",
    AU = "AU",

    Profanity = "Profanity",
    Violence = "Violence",
    Death = "Death",
    Sex = "Sex",
    Gore = "Gore",

    SciFi = "Sci-Fi",
    SoL = "Slice of Life",
    Mystery = "Mystery",
    Anthology = "Anthology",

    Romance = "Romance",
    Comedy = "Comedy",
    Adventure = "Adventure",
    Drama = "Drama"
}

/**
 * Represents a single fanfic instance.
 */
export interface iFanfic {
    name: string,
    url: string,
    image: string,

    tags: Array<Tags>,

    length: number,
    recommends: number, // The amount of nominations gathered from the thread.

    desc: string,
    reviews: Array<string>,

    upVotes: number,
    downVotes: number,
    rating: "E" | "T" | "M",
}

/**
 * Used to store the user's sorting options.
 */
export interface SortOptions {
    sortBy: "wordcount" | "upvotes" | "recommendations" | "wilson",
    tags: Map<Tags, boolean>,
    sortDirection: "ascending" | "descending",
}
